<?php

namespace ZGIT\NatayarkID;

use XF\AddOn\AbstractSetup;
use XF\AddOn\StepRunnerInstallTrait;
use XF\AddOn\StepRunnerUninstallTrait;
use XF\AddOn\StepRunnerUpgradeTrait;

class Setup extends AbstractSetup
{
  use StepRunnerInstallTrait;
  use StepRunnerUpgradeTrait;
  use StepRunnerUninstallTrait;

  public function installStep1(array $stepParams = [])
  {
      $this->db()->insert('xf_connected_account_provider', [
          'provider_id' => 'zgit_cap_natayarkid',
          'provider_class' => 'ZGIT\\NatayarkID:Provider\\NatayarkID',
          'display_order' => 500,
          'options' => ''
        ], true);
  }

  public function uninstall(array $stepParams = [])
  {
    $this->db()->delete('xf_connected_account_provider', "provider_id LIKE 'zgit_cap_natayarkid'");
  }
}
