<?php

namespace ZGIT\NatayarkID\ConnectedAccount\Service;

use OAuth\Common\Consumer\CredentialsInterface;
use OAuth\Common\Http\Client\ClientInterface;
use OAuth\Common\Http\Exception\TokenResponseException;
use OAuth\Common\Http\Uri\Uri;
use OAuth\Common\Http\Uri\UriInterface;
use OAuth\Common\Storage\TokenStorageInterface;
use \OAuth\OAuth2\Service\AbstractService;
use OAuth\OAuth2\Token\StdOAuth2Token;
use XF;

class NatayarkID extends AbstractService
{
  const SCOPE_BASIC = 'basic';

  public function __construct(
    CredentialsInterface $credentials,
    ClientInterface $httpClient,
    TokenStorageInterface $storage,
    $scopes = array(),
    UriInterface $baseApiUri = null
  ) {
    parent::__construct(
      $credentials,
      $httpClient,
      $storage,
      $scopes,
      $baseApiUri,
      true
    );

    if (null === $baseApiUri) {
      $this->baseApiUri = new Uri('https://account.naids.com/api/');
    }
  }

  protected function getAuthorizationMethod()
  {
    return static::AUTHORIZATION_METHOD_HEADER_BEARER;
  }

  public function getAuthorizationEndpoint()
  {
    return new Uri('https://account.naids.com/oauth2/authorize');
  }

  public function getAccessTokenEndpoint()
  {
    return new Uri('https://account.naids.com/api/oauth2/token');
  }

  protected function parseAccessTokenResponse($responseBody)
  {
    $data = json_decode($responseBody, true);
    if (null === $data || !is_array($data)) {
      throw new TokenResponseException('Unable to parse response.');
    } elseif ($data['code'] !== 200) {
      throw new TokenResponseException('Error in retrieving token: "' . $data['msg'] . '"');
    }

    $token = new StdOAuth2Token();
    $token->setAccessToken($data['access_token']);
    $token->setLifetime($data['expires_in']);

    if (isset($data['refresh_token'])) {
      $token->setRefreshToken($data['refresh_token']);
      unset($data['refresh_token']);
    }

    unset($data['access_token']);
    unset($data['expires_in']);

    $token->setExtraParams($data);

    return $token;
  }
}
